#ifndef _HANDSHAKE_CPP
#define _HANDSHAKE_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <WindowsX.H>
#include <ShellAPI.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../Resources/Resource.H"
#include "../../SharedClasses/CRC32/CRC.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "NSWFL.H"
#include "Init.H"
#include "Entry.H"
#include "Routines.H"
#include "WinService.H"
#include "HandShake.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void BinPrint(const char *sData, int iLen)
{
	int iRPos = 0;
	while(iRPos < iLen)
	{
		printf("%X\n", sData[iRPos]);
		iRPos++;
	}
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
	int PerformHandShake(int iClient, char *sRecvBuf, int iRecvBufSz)

	Performs a hand shake. Also know as Client/Server Authentication.

	Possible return Values:
		AUTH_FAILED   //The authentication process failed.
		AUTH_SUCCESS  //The authentication process was a success.
		AUTH_OK       //The authentication process is still in process, all is well.
		AUTH_ERROR    //The authentication process failed due to an error.
*/
int PerformHandShake(CSockSrvr *pSockSrvr, int iClient, char *sCmdBuf, int iCmdBufSz)
{
    char sCmdData[IDEAL_RECV_SIZE + 1];
    char sSendBuf[IDEAL_SEND_SIZE + 1];
    char sTemp[IDEAL_SEND_SIZE + 1];

	int iCmdDataSz = 0;
	int iSendBufSz = 0;
	int iCmdFlagLength = 0;

	if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RawHash->")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Server requested key hash.");
		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		CipherKey(sCmdData, sCmdData, iCmdDataSz);
		pSockSrvr->SetNextSendDataEx(iClient, sCmdData, iCmdDataSz);
		return AUTH_OK;
	}
	else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestAuthString")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Server requested authentication.");

		int iTempLen = strlen(gsAuthString);

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);
		CCI.cNASCCL.Encode(gsAuthString, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::AuthString->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::NewAuthKey->")))
    {
		char sNewAuthKey_Raw[MAX_KEY_LENGTH];

		WriteLog(pSockSrvr->icClientID[iClient], "Server issued new cryptography key.");

		int iTempLen = strlen(gsAuthString);

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

		CCI.cNASCCL.Decode(sCmdData, sNewAuthKey_Raw, iCmdDataSz);
		sNewAuthKey_Raw[iCmdDataSz] = '\0';
		CCI.cNASCCL.UninitializeCryptographySet();
		memset(&CCI.cNASCCL, 0, sizeof(CCI.cNASCCL));

		if(!CCI.cNASCCL.InitializeCryptographySet(sNewAuthKey_Raw, iCmdDataSz, CRYPTFLAGS))
		{
			WriteLog(pSockSrvr->icClientID[iClient], "Failed to Initialize the cryptography set.");
		}

		CCI.cNASCCL.Encode(gsAuthString, sTemp, iTempLen);

		iSendBufSz = AppendDataToCmd("::NewKeyAuth->", sTemp, iTempLen, sSendBuf);

		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestVersion")))
    {
		int iTempLen = strlen(gsFileVersion);

		CCI.cNASCCL.Encode(gsFileVersion, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::Version->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestCompanyName")))
    {
		int iTempLen = strlen(gsCompanyName);

		CCI.cNASCCL.Encode(gsCompanyName, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::CompanyName->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::RequestPassword")))
    {
		int iTempLen = strlen(gsCompanyPassword);

		CCI.cNASCCL.Encode(gsCompanyPassword, sTemp, iTempLen);
		iSendBufSz = AppendDataToCmd("::Password->", sTemp, iTempLen, sSendBuf);
		pSockSrvr->SetNextSendDataEx(iClient, sSendBuf, iSendBufSz);
		return AUTH_OK;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::AuthenticationSuccess")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Authentication success.");
		return AUTH_SUCCESS;
	}
    else if((iCmdFlagLength = CmdCmp(sCmdBuf, "::AutoUpdate->")))
    {
		WriteLog(pSockSrvr->icClientID[iClient], "Starting automatic update process.");

		iCmdDataSz = BreakCmdFromData(sCmdBuf, iCmdFlagLength, iCmdBufSz, sCmdData);

        char OldExe[MAX_PATH];
        char NewExe[MAX_PATH];

        sprintf(OldExe, "%s\\%s", gsPath, "AutoUpdate.Exe");
        sprintf(NewExe, "%s\\%s", Get_TempDirectory(), "SQLEUpdate.Exe");

        CopyFile(OldExe, NewExe, FALSE);
        ShellExecute(GetActiveWindow(), "Open", NewExe, sCmdData, Get_CurrentDirectory(), SW_SHOWNORMAL);
        xCommandService(SERVICE_CONTROL_STOP);

		return AUTH_SUCCESS;
	}

	return AUTH_ERROR;	
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
